
////////////////////////////////////////////////////////////
//	File:		"Sprite.cpp"
//	Author:		[JW] Jason Ware
//	Modified:	[JW] November 17, 2008
//	Purpose:	Holds all the animations for a given sprite sheet.
////////////////////////////////////////////////////////////

#include "Sprite.h"

/* Data Members */

/* Constructors */

CSprite::CSprite()
{
	m_nImageID = -1;
}

CSprite::CSprite(string szSpriteSheetName)
{
	m_szSpriteSheetName = szSpriteSheetName;
}

/* Accessors */

/* Mutators */

/* Other Functions */

/* Destructor */

CSprite::~CSprite()
{
	Clear();
}

////////////////////////////////////////////////////////////
	//	Function:	GetAnimation
	//	Modified:	[JW] November 17, 2008
	//	Purpose:	Returns the given animation.
	////////////////////////////////////////////////////////////
CAnimation* CSprite::GetAnimation(const string szAnimName)
{
	for(unsigned int i = 0; i < m_vAnimationList.size(); i++)
		if(m_vAnimationList[i]->GetAnimationName() == szAnimName)
			return m_vAnimationList[i];

	return NULL;
}

	////////////////////////////////////////////////////////////
	//	Function:	Clear
	//	Modified:	[JW] November 17, 2008
	//	Purpose:	Removes all the animations and their frames.
	////////////////////////////////////////////////////////////
void CSprite::Clear()
{
	for(unsigned int i = 0; i < m_vAnimationList.size(); i++)
	{
		m_vAnimationList[i]->Clear();
		delete m_vAnimationList[i];
	}

	m_vAnimationList.clear();
}

/* Protected Functions */

/* Private Functions */

